function Component() {
    // Connect installation finished function with the finish button being clicked
    installer.finishButtonClicked.connect(this,
                                          Component.prototype.installationFinished);

    // Hide this package if incorrect architecture
    // If virtual is true it will hide it in the ui
    // If default is true it will be checked by default
    component.setValue("Virtual", "true");
    if (systemInfo.currentCpuArchitecture === "x86_64") {
        component.setValue("Virtual", "false");
        component.setValue("Default", "true");
    }
}

Component.prototype.createOperations = function() {
    component.createOperations();
    if (systemInfo.productType === "windows") {
        // Create start menu shortcut
        component.addOperation("CreateShortcut",
                               "@TargetDir@/Strong ER/MMS.exe",
                               "@StartMenuDir@/Strong ER.lnk");

        // Create desktop shortcut
        var userProfile = installer.environmentVariable("USERPROFILE");
        installer.setValue("UserProfile", userProfile);
        component.addOperation("CreateShortcut",
                               "@TargetDir@/Strong ER/MMS.exe",
                               "@UserProfile@/Desktop/Strong ER.lnk");
    }
}

Component.prototype.installationFinished = function() {
    try {
        if ((installer.isInstaller() || installer.isUpdater()) &&
                installer.status === QInstaller.Success &&
                component.installed) {
            QDesktopServices.openUrl("file:///" + installer.value("TargetDir") +
                                     "/Strong ER/RunAsAdministrator.bat");
        }
    } catch(e) {
        console.log(e);
    }
}
