function Component() {
    // Connect installation finished function with the finish button being clicked
    installer.finishButtonClicked.connect(this,
                                          Component.prototype.installationFinished);

    // Hide this package if incorrect architecture
    // If virtual is true it will hide it in the ui
    // If default is true it will be checked by default
    component.setValue("Virtual", "true");
    if (systemInfo.currentCpuArchitecture === "i386" ||
            systemInfo.currentCpuArchitecture === "x86_64") {
        component.setValue("Virtual", "false");
    }
}

Component.prototype.createOperations = function() {
    component.createOperations();
    // Exit current Strong Integration
    // Exit Codes:
    //     0   Successful
    //     128 The Process was not found
    component.addOperation("Execute",
                           "{0,128}",
                           "taskkill",
                           "/F",
                           "/IM",
                           "strong-integration.exe")
    if (systemInfo.productType === "windows") {
        // Create start menu shortcut
        component.addOperation("CreateShortcut",
                               "@TargetDir@/Strong Integration/strong-integration.exe",
                               "@StartMenuDir@/Strong Integration.lnk");

        // Create desktop shortcut
        var userProfile = installer.environmentVariable("USERPROFILE");
        installer.setValue("UserProfile", userProfile);
        component.addOperation("CreateShortcut",
                               "@TargetDir@/Strong Integration/strong-integration.exe",
                               "@UserProfile@/Desktop/Strong Integration.lnk");
    }
}

Component.prototype.installationFinished = function() {
    try {
        if ((installer.isInstaller() || installer.isUpdater()) &&
                installer.status === QInstaller.Success &&
                component.installed) {
            QDesktopServices.openUrl("file:///" + installer.value("TargetDir") +
                                     "/Strong Integration/strong-integration.exe");
        }
    } catch(e) {
        console.log(e);
    }
}
